/*
 * Decompiled with CFR 0.152.
 */
package com.elp.apielp.BDD;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
public class Function {
    public static String sha256(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] hashBytes = md.digest(input.getBytes(StandardCharsets.UTF_8));
            StringBuilder hexString = new StringBuilder();
            for (byte b : hashBytes) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-256 algorithm not available", e);
        }
    }

    public static int calculerNombreAnnees(LocalDate dateDebut, LocalDate dateFin) {
        if (dateDebut == null || dateFin == null) {
            throw new IllegalArgumentException("Les dates ne doivent pas \u00eatre nulles");
        }
        Period periode = Period.between(dateDebut, dateFin);
        return periode.getYears();
    }

    public static String formatDate(LocalDateTime date) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("d MMMM yyyy", Locale.FRENCH);
        return date.format(formatter);
    }

    public static String formatDateByFormat(LocalDate date, String format) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format, Locale.FRENCH);
        return date.format(formatter);
    }

    public static List<Map<String, LocalDate>> getWeeklyIntervals(int year, int month) {
        ArrayList<Map<String, LocalDate>> weeks = new ArrayList<Map<String, LocalDate>>();
        LocalDate firstDayOfMonth = LocalDate.of(year, month, 1);
        LocalDate lastDayOfMonth = firstDayOfMonth.with(TemporalAdjusters.lastDayOfMonth());
        LocalDate start = firstDayOfMonth.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
        LocalDate end = lastDayOfMonth.with(TemporalAdjusters.nextOrSame(DayOfWeek.FRIDAY));
        LocalDate current = start;
        while (!current.isAfter(end)) {
            LocalDate monday = current;
            LocalDate friday = current.with(TemporalAdjusters.nextOrSame(DayOfWeek.FRIDAY));
            HashMap<String, LocalDate> weekRange = new HashMap<String, LocalDate>();
            weekRange.put("Monday", monday);
            weekRange.put("Friday", friday);
            if (monday.getMonth().getValue() == month || friday.getMonth().getValue() == month) {
                weeks.add(weekRange);
            }
            current = monday.plusWeeks(1L);
        }
        return weeks;
    }

    public static void main(String[] args) {
        int year = 2025;
        int month = 2;
        List intervals = Function.getWeeklyIntervals((int)year, (int)month);
        for (Map week : intervals) {
            System.out.println("Semaine : " + week.get("Monday") + " -> " + week.get("Friday"));
        }
    }
}

