/*
 * Decompiled with CFR 0.152.
 */
package com.elp.apielp.Controller;

import com.elp.apielp.DAO.CongeDao;
import com.elp.apielp.DAO.InfoConge;
import com.elp.apielp.Model.Conge;
import com.elp.apielp.Service.CongeService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/conge"})
public class CongeController {
    @Autowired
    private CongeService service;

    @PostMapping(value={"/save"})
    public ResponseEntity<?> saveConge(@RequestBody CongeDao input) {
        try {
            Conge m = this.service.create(input);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)m);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)e.getMessage());
        }
    }

    @GetMapping(value={"/{idEmp}"})
    public List<Conge> getAllConge(@PathVariable long idEmp) {
        return this.service.getAllConge(idEmp);
    }

    @GetMapping(value={"/solde/{idEmp}"})
    public double getSolde(@PathVariable long idEmp) {
        return this.service.getSolde(idEmp);
    }

    @GetMapping(value={"/perMonth/{an}/{idEmp}"})
    public double[] getPerMon(@PathVariable int an, @PathVariable long idEmp) {
        return this.service.getPerMonth(an, idEmp);
    }

    @GetMapping(value={"/info/{idEmp}/{mois}/{an}"})
    public List<InfoConge> getInfo(@PathVariable long idEmp, @PathVariable int mois, @PathVariable int an) {
        return this.service.getInfo(an, mois, idEmp);
    }

    @DeleteMapping(value={"/delete/{idConge}"})
    public ResponseEntity<?> deleteConge(@PathVariable long idConge) {
        this.service.delete(idConge);
        return ResponseEntity.ok((Object)"Suppression avec sucess");
    }

    @GetMapping(value={"/nonValider"})
    public List<Conge> congeNonValide() {
        return this.service.getByStatutNonValide();
    }

    @PutMapping(value={"/modif"})
    public void modif(@RequestBody Conge conge) {
        this.service.modif(conge);
    }
}

