/*
 * Decompiled with CFR 0.152.
 */
package com.elp.apielp.Controller;

import com.elp.apielp.BDD.Function;
import com.elp.apielp.Composant.MessageConverterJson;
import com.elp.apielp.DAO.Allinfo;
import com.elp.apielp.Model.Employe;
import com.elp.apielp.Model.EtatEmployer;
import com.elp.apielp.Model.Notification.Notification;
import com.elp.apielp.Model.Notification.TitreNotif;
import com.elp.apielp.Repository.EmployeRepository;
import com.elp.apielp.Repository.Notif.TitreNotifRepository;
import com.elp.apielp.Service.LoginService;
import com.elp.apielp.Service.NotificationService;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Controller
@RestController
@RequestMapping(value={"/employe"})
public class EmployeController {
    @Autowired
    private LoginService employeService;
    @Autowired
    private SimpMessagingTemplate messagingTemplate;
    @Autowired
    private NotificationService notificationService;
    @Autowired
    private EmployeRepository employeRepository;
    @Autowired
    private TitreNotifRepository titreNotifRepository;

    @GetMapping(value={"/all"})
    public List<EtatEmployer> getAllEmployes() {
        return this.employeService.getAllEmployes(Employe.Validation.VALIDER);
    }

    @GetMapping(value={"/nonValider"})
    public List<EtatEmployer> getEmpNonValider() {
        return this.employeService.getAllEmployes(Employe.Validation.NON_VALIDER);
    }

    @PostMapping(value={"/"})
    public ResponseEntity<String> createUser(@RequestBody Allinfo allinfo) throws Exception {
        try {
            int[] idAdmins = this.employeRepository.getAdmin();
            Employe e = this.employeService.createUser(allinfo);
            Notification t = new Notification();
            t.setDateInsert(LocalDateTime.now());
            t.setDateVue(null);
            t.setEmpResp(e);
            t.setIdObject(t.getEmpResp().getIdEmp().longValue());
            t.setTitreNotif((TitreNotif)this.titreNotifRepository.getReferenceById((Object)2));
            t.setMessageFinal(new String[]{e.getNom() + " " + e.getPrenom(), e.getMatricule(), Function.formatDate((LocalDateTime)t.getDateInsert())});
            this.notificationService.save(t, idAdmins);
            return this.employeService.authentification(allinfo.getLogin(), allinfo.getMdp());
        }
        catch (RuntimeException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @DeleteMapping(value={"/{idEmp}"})
    public void deleteEmp(@PathVariable long idEmp) {
    }

    @PutMapping(value={"/{idEmp}"})
    public void validateUser(@PathVariable long idEmp) {
        this.employeService.valider(idEmp);
        String destination = "/notif/validation/" + idEmp;
        this.messagingTemplate.convertAndSend((Object)destination, (Object)"Votre compte a \u00e9t\u00e9 valid\u00e9 !");
    }

    @PutMapping(value={"/modif"})
    public ResponseEntity<String> modifEmp(@RequestBody EtatEmployer employer) {
        try {
            this.employeService.modifEmp(employer);
            this.notificationService.sendNotif("/notif/modification/" + employer.getEmp().getEmploye().getIdEmp(), (Object)new MessageConverterJson(String.format("Votre information a \u00e9t\u00e9 mise \u00e0 jour par l'administrateur! Nouvelle M\u00b0: %s ", employer.getEmp().getEmploye().getMatricule()), LocalDateTime.now()));
            return ResponseEntity.ok((Object)"Modification effectu\u00e9e avec succ\u00e8s");
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Erreur lors de la modification: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/gets"})
    public List<Employe> employeList() {
        return this.employeRepository.findAllByValidation(Employe.Validation.VALIDER);
    }
}

