/*
 * Decompiled with CFR 0.152.
 */
package com.elp.apielp.Controller;

import com.elp.apielp.PathOS;
import java.nio.file.Path;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class FileUpload {
    private final PathOS pathOS;

    public FileUpload(PathOS pathOS) {
        this.pathOS = pathOS;
    }

    @GetMapping(value={"/{filename}"})
    public ResponseEntity<Resource> serveFile(@PathVariable String filename) {
        try {
            Path file = this.pathOS.getUploadDirectory().resolve(filename);
            UrlResource resource = new UrlResource(file.toUri());
            if (resource.exists() || resource.isReadable()) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"" + filename + "\""})).body((Object)resource);
            }
            return ResponseEntity.notFound().build();
        }
        catch (Exception e) {
            return ResponseEntity.badRequest().build();
        }
    }
}

