/*
 * Decompiled with CFR 0.152.
 */
package com.elp.apielp.Service;

import com.elp.apielp.DAO.Allinfo;
import com.elp.apielp.JwtUtil;
import com.elp.apielp.Model.Employe;
import com.elp.apielp.Model.EtatEmployer;
import com.elp.apielp.Model.InfoRh;
import com.elp.apielp.Model.Login;
import com.elp.apielp.Model.Pointage;
import com.elp.apielp.Model.TempLogin;
import com.elp.apielp.Model.Type;
import com.elp.apielp.PathOS;
import com.elp.apielp.Repository.EmployeRepository;
import com.elp.apielp.Repository.EtatEmployeRepository;
import com.elp.apielp.Repository.InfoRhRepository;
import com.elp.apielp.Repository.LoginRepository;
import com.elp.apielp.Repository.PointageRepository;
import com.elp.apielp.Repository.TempLoginRepository;
import com.elp.apielp.Repository.TypeRepository;
import java.io.IOException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LoginService
implements UserDetailsService {
    @Autowired
    private LoginRepository loginRepository;
    @Autowired
    private PathOS pathOS;
    @Autowired
    private EmployeRepository employeRepository;
    @Autowired
    private TypeRepository typeRepository;
    @Autowired
    private TempLoginRepository tempLoginRepository;
    @Autowired
    private InfoRhRepository rh;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private JwtUtil jwtUtil;
    @Autowired
    private PointageRepository pointageRepository;
    @Autowired
    private EtatEmployeRepository etatEmployeRepository;

    @Transactional
    public Employe createUser(Allinfo info) throws IOException {
        if (this.loginRepository.existsByLogin(info.getLogin())) {
            throw new RuntimeException("Login d\u00e9j\u00e0 existant");
        }
        Type type = (Type)this.typeRepository.findById((Object)info.getType().getIdType()).orElseThrow(() -> new RuntimeException("Type not found"));
        Employe employe = new Employe();
        employe.setType(type);
        employe.setNom(info.getNom());
        employe.setPrenom(info.getPrenom());
        employe.setNaissance(info.getNaissance());
        employe.setTel(info.getTel());
        employe.setAdresse(info.getAdresse());
        employe.setCin(info.getCin());
        employe.setValide(info.getValide());
        employe.setNationalite(info.getNationalite());
        employe.setGenre(info.getGenre());
        employe.setStatut(info.getStatut());
        employe.setNiveau(info.getNiveau());
        employe.setEnfant(info.getEnfant());
        employe.setProfile(Allinfo.savePNG((String)info.getProfile(), (String)info.getLogin(), (PathOS)this.pathOS));
        employe.setMatricule(info.getLogin());
        this.employeRepository.save((Object)employe);
        InfoRh infoRh = new InfoRh();
        infoRh.setEmploye(employe);
        infoRh.setDateEntre(info.getEntre());
        infoRh.setNumCnaps(info.getNumCanps());
        infoRh.setBanque(info.getBanque());
        infoRh.setRib(info.getRib());
        infoRh.setContact(info.getContact());
        infoRh.setTel(info.getTel());
        this.rh.save((Object)infoRh);
        EtatEmployer etatEmployer = new EtatEmployer();
        etatEmployer.setEtat(EtatEmployer.Etat.ACTIF);
        etatEmployer.setEmp(infoRh);
        this.etatEmployeRepository.save((Object)etatEmployer);
        Login loginEntity = new Login(employe.getIdEmp(), info.getLogin(), this.passwordEncoder.encode((CharSequence)info.getMdp()), employe);
        this.loginRepository.save((Object)loginEntity);
        return employe;
    }

    @Transactional
    public void deleteUser(Long idUser) {
        this.tempLoginRepository.deleteByEmploye_IdEmp(idUser);
        this.loginRepository.deleteAllByEmploye_IdEmp(idUser.longValue());
        this.rh.deleteAllByEmploye_IdEmp(idUser.longValue());
        this.employeRepository.deleteById((Object)idUser);
    }

    @Transactional
    public void setSession(Employe employe) {
        TempLogin temp = new TempLogin();
        temp.setIdUser(employe.getIdEmp().longValue());
        temp.setEmploye(employe);
        this.tempLoginRepository.save((Object)temp);
    }

    @Transactional(readOnly=true)
    public List<EtatEmployer> getAllEmployes(Employe.Validation validation) {
        return this.etatEmployeRepository.findByEmp_Employe_ValidationOrderByIdEtatDesc(validation);
    }

    @Transactional(readOnly=true)
    public Employe login(String login, String mdp) throws Exception {
        Login foundLogin = this.loginRepository.findByLogin(login);
        if (foundLogin != null && this.passwordEncoder.matches((CharSequence)mdp, foundLogin.getMdp())) {
            return foundLogin.getEmploye();
        }
        throw new Exception("Invalid login or password");
    }

    public boolean isSessionSet(Employe log) {
        return this.tempLoginRepository.getSessionToDay(log.getIdEmp().longValue()).size() != 0;
    }

    public ResponseEntity<String> authentification(String login, String mdp) throws Exception {
        Employe emp = this.login(login, mdp);
        ZonedDateTime zonedDateTime = ZonedDateTime.now(ZoneId.of("Indian/Antananarivo"));
        if (this.isSessionSet(emp)) {
            return ResponseEntity.status((int)401).body((Object)"Cet utilisateur a d\u00e9j\u00e0 une session!");
        }
        Pointage p = this.pointageRepository.findPointageWithDateDebutToday(emp.getIdEmp().longValue());
        if (p == null) {
            Pointage pointage = new Pointage();
            pointage.setEmploye(emp);
            pointage.setDateDebut(zonedDateTime.toLocalDateTime());
            pointage.setDateFin(null);
            this.pointageRepository.save((Object)pointage);
        }
        this.setSession(emp);
        UserDetails userDetails = this.loadUserByUsername(login);
        String jwt = this.jwtUtil.generateToken(userDetails, emp.getIdEmp().longValue());
        return ResponseEntity.ok((Object)jwt);
    }

    @Transactional
    public ResponseEntity<String> logOut(String token) {
        Employe emp = (Employe)this.employeRepository.findById((Object)this.jwtUtil.getIdEmp(token)).orElseThrow();
        if (emp == null) {
            return ResponseEntity.status((int)401).body((Object)"Vous n'\u00eates pas autoris\u00e9 pour faire ce requ\u00eate");
        }
        Login login = this.loginRepository.findByEmploye_IdEmp(emp.getIdEmp().longValue());
        if (!login.getLogin().equals(this.jwtUtil.extractUsername(token))) {
            return ResponseEntity.status((int)401).body((Object)"Vous n'\u00eates pas autoris\u00e9 pour faire ce requ\u00eate");
        }
        this.tempLoginRepository.deleteByEmploye_IdEmp(emp.getIdEmp());
        Pointage pointage = this.pointageRepository.findPointageWithDateDebutToday(emp.getIdEmp().longValue());
        if (pointage != null) {
            ZonedDateTime zonedDateTime = ZonedDateTime.now(ZoneId.of("Indian/Antananarivo"));
            pointage.setDateFin(zonedDateTime.toLocalDateTime());
            this.pointageRepository.save((Object)pointage);
        }
        return ResponseEntity.ok((Object)"Vous avez d\u00e9connect\u00e9!");
    }

    public boolean isTokenValide(String token) {
        String username = this.jwtUtil.extractUsername(token);
        UserDetails userDetails = this.loadUserByUsername(username);
        return this.jwtUtil.validateToken(token, userDetails);
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        Login user = this.loginRepository.findByLogin(username);
        if (user == null) {
            throw new UsernameNotFoundException("User not found");
        }
        return new User(user.getLogin(), user.getMdp(), new ArrayList());
    }

    public Allinfo getById(String token) throws Exception {
        long id = this.jwtUtil.getIdEmp(token);
        Employe emp = (Employe)this.employeRepository.findById((Object)id).orElseThrow(() -> new Exception("Cet utilisateur n'est pas valide"));
        InfoRh rhinfo = this.rh.getByEmploye_IdEmp(emp.getIdEmp().longValue());
        Login log = this.loginRepository.findByEmploye_IdEmp(emp.getIdEmp().longValue());
        Allinfo e = new Allinfo(emp.getType(), emp.getNom(), emp.getPrenom(), emp.getNaissance(), emp.getTel(), emp.getAdresse(), emp.getCin(), emp.getValide(), emp.getNationalite(), emp.getGenre(), emp.getStatut(), emp.getEnfant(), emp.getNiveau(), rhinfo.getDateEntre(), rhinfo.getNumCnaps(), rhinfo.getBanque(), rhinfo.getRib(), rhinfo.getContact(), rhinfo.getTel(), log.getLogin(), log.getMdp(), emp.getIdEmp().longValue(), emp.getProfile(), emp.getMatricule());
        e.setValidation(emp.getValidation());
        return e;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional
    public ResponseEntity<String> updateEmp(Allinfo info, String prevMdp) throws Exception {
        Employe employe;
        Login loginEntity;
        if (!(prevMdp = prevMdp.replaceAll("\\-\\+", "/")).equals((loginEntity = this.loginRepository.findByEmploye_IdEmp((employe = (Employe)this.employeRepository.findById((Object)info.getIdEmp()).orElseThrow(() -> new Exception("cet employ\u00e9 n'est pas valide"))).getIdEmp().longValue())).getMdp())) {
            if (!this.passwordEncoder.matches((CharSequence)prevMdp, loginEntity.getMdp())) return ResponseEntity.status((int)400).body((Object)"Pr\u00e9cedent mot de passe non valide!");
            List allbyLogin = this.loginRepository.findAllByLogin(info.getLogin());
            if (allbyLogin.size() != 0 && (allbyLogin.size() != 1 || ((Login)allbyLogin.get(0)).getId().intValue() != loginEntity.getId().intValue())) return ResponseEntity.status((int)400).body((Object)"Changez votre login!");
            loginEntity.setLogin(info.getLogin());
            loginEntity.setMdp(this.passwordEncoder.encode((CharSequence)info.getMdp()));
            this.loginRepository.save((Object)loginEntity);
            this.tempLoginRepository.deleteByEmploye_IdEmp(employe.getIdEmp());
        }
        employe.setType(info.getType());
        employe.setNom(info.getNom());
        employe.setPrenom(info.getPrenom());
        employe.setNaissance(info.getNaissance());
        employe.setTel(info.getTel());
        employe.setAdresse(info.getAdresse());
        employe.setCin(info.getCin());
        employe.setValide(info.getValide());
        employe.setNationalite(info.getNationalite());
        employe.setGenre(info.getGenre());
        employe.setStatut(info.getStatut());
        employe.setNiveau(info.getNiveau());
        employe.setEnfant(info.getEnfant());
        this.employeRepository.save((Object)employe);
        InfoRh infoRh = this.rh.getByEmploye_IdEmp(employe.getIdEmp().longValue());
        infoRh.setDateEntre(info.getEntre());
        infoRh.setNumCnaps(info.getNumCanps());
        infoRh.setBanque(info.getBanque());
        infoRh.setRib(info.getRib());
        infoRh.setContact(info.getContact());
        infoRh.setTel(info.getTel());
        this.rh.save((Object)infoRh);
        return ResponseEntity.ok((Object)"votre information a \u00e9t\u00e9 mis \u00e0 jour");
    }

    public void valider(long idEmp) {
        Employe emp = (Employe)this.employeRepository.findById((Object)idEmp).orElseThrow();
        emp.setValidation(Employe.Validation.VALIDER);
        this.employeRepository.save((Object)emp);
    }

    @Transactional
    public void modifEmp(EtatEmployer e) throws Exception {
        Employe emp = e.getEmp().getEmploye();
        Login loginEntity = this.loginRepository.findByLogin(emp.getMatricule());
        if (loginEntity == null) {
            Login newLogin = this.loginRepository.findByEmploye_IdEmp(emp.getIdEmp().longValue());
            newLogin.setLogin(emp.getMatricule());
            this.loginRepository.save((Object)newLogin);
        } else if (loginEntity.getIdUser() != emp.getIdEmp()) {
            throw new Exception(String.format("La M\u00b0 %s d\u00e9j\u00e0 prise", emp.getMatricule()));
        }
        this.employeRepository.save((Object)emp);
        this.rh.save((Object)e.getEmp());
    }
}

