/*
 * Decompiled with CFR 0.152.
 */
package com.elp.apielp.Service;

import com.elp.apielp.DAO.PointageDAO;
import com.elp.apielp.JwtUtil;
import com.elp.apielp.Model.Pointage;
import com.elp.apielp.Repository.PointageRepository;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PointageService {
    @Autowired
    private PointageRepository pointageRepository;
    @Autowired
    private JwtUtil jwtUtil;

    public PointageDAO getMonPointage(String token) {
        long id = this.jwtUtil.getIdEmp(token);
        ZoneId zoneId = ZoneId.of("Indian/Antananarivo");
        Pointage pointage = this.pointageRepository.findPointageWithDateDebutToday(id);
        if (pointage == null) {
            return null;
        }
        if (pointage.getDateFin() == null) {
            return new PointageDAO(Date.from(pointage.getDateDebut().atZone(zoneId).toInstant()), null);
        }
        return new PointageDAO(Date.from(pointage.getDateDebut().atZone(zoneId).toInstant()), Date.from(pointage.getDateFin().atZone(ZoneId.systemDefault()).toInstant()));
    }

    public List<PointageDAO> getPerMonth(long idEmp, int month, int year) {
        ArrayList<PointageDAO> all = new ArrayList<PointageDAO>();
        List pointages = this.pointageRepository.getPointageByIdEmp(idEmp, month, year);
        ZoneId zoneId = ZoneId.of("Indian/Antananarivo");
        for (Pointage pointage : pointages) {
            if (pointage.getDateFin() == null) {
                all.add(new PointageDAO(Date.from(pointage.getDateDebut().atZone(zoneId).toInstant()), null));
                continue;
            }
            all.add(new PointageDAO(Date.from(pointage.getDateDebut().atZone(zoneId).toInstant()), Date.from(pointage.getDateFin().atZone(ZoneId.systemDefault()).toInstant())));
        }
        return all;
    }

    public void setDateFin(String token) {
        long id = this.jwtUtil.getIdEmp(token);
        Pointage pointage = this.pointageRepository.findPointageWithDateDebutToday(id);
        if (pointage != null) {
            ZonedDateTime zonedDateTime = ZonedDateTime.now(ZoneId.of("Indian/Antananarivo"));
            pointage.setDateFin(zonedDateTime.toLocalDateTime());
            this.pointageRepository.save((Object)pointage);
        }
    }
}

