/*
 * Decompiled with CFR 0.152.
 */
package com.elp.apielp.Service;

import com.elp.apielp.Model.Employe;
import com.elp.apielp.Model.RenduFile;
import com.elp.apielp.PathOS;
import com.elp.apielp.Repository.EmployeRepository;
import com.elp.apielp.Repository.RenduFileRepository;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class RenduFileService {
    @Autowired
    private RenduFileRepository rendu;
    @Autowired
    private PathOS pathOS;
    @Autowired
    EmployeRepository emp;

    private String saveFile(MultipartFile file) throws IOException {
        Path uploadPath = this.pathOS.getUploadDirectory().normalize();
        String uniqueFileName = UUID.randomUUID().toString() + "-" + Objects.requireNonNull(file.getOriginalFilename()).replaceAll("-", "");
        if (!Files.exists(uploadPath, new LinkOption[0])) {
            Files.createDirectories(uploadPath, new FileAttribute[0]);
        }
        Path targetPath = uploadPath.resolve(uniqueFileName);
        file.transferTo(targetPath.toFile());
        return uniqueFileName;
    }

    public void uploadFiles(String reference, List<MultipartFile> files, long idEmp) throws IOException {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (MultipartFile file : files) {
            String fileName = this.saveFile(file);
            fileNames.add(fileName);
        }
        Employe e = (Employe)this.emp.getReferenceById((Object)idEmp);
        RenduFile document = new RenduFile(reference, fileNames, e);
        this.rendu.save((Object)document);
    }

    public List<RenduFile> getAllRenduFile(int month, int year, long idEmp) {
        return this.rendu.getRenduFilesDateMonth(idEmp, year, month);
    }

    public List<RenduFile> getRenduFilesByWeek(Long idEmploye, LocalDate startDate, LocalDate endDate) {
        return this.rendu.getRenduFilesByWeek(idEmploye, startDate, endDate);
    }
}

