insert into type (poste) values ('Direction'),('Ingénieurs en BTP'),('Développeur'),('Technicien');
insert into genre values (1,'Homme'),(2,'Femme'),(3,'Autre');
insert into statut values (1,'Célibataire'),(2,'Marié(e)'),(3,'Séparé(e)'),(4,'Veuf/veuve'),(5,'En union libre');
insert into niveau values  (1,'< Bac'),(2,'Bac +'),(3,'Licence'),(4,'Master I'),(5,'Master II');
insert into banque values (1,'BOA Madagascar'),(2,'BNI Madagascar'),(3,'Société générale Madagasikara (BFV - SG)'),(4,'BMOI'),(5,'AccèsBanque Madagascar');

CREATE OR REPLACE FUNCTION getDateFin(dateFin DATE, mois INT, anne INT)
    RETURNS DATE AS $$
BEGIN
    IF mois = EXTRACT(MONTH FROM dateFin) AND anne = EXTRACT(YEAR FROM dateFin) THEN
        RETURN dateFin;
    elseif (make_date(anne, mois, 1)  + INTERVAL '1 MONTH' - INTERVAL '1 day') < dateFin THEN
        return (make_date(anne, mois, 1)  + INTERVAL '1 MONTH' - INTERVAL '1 day');
    else
        return null;
    END IF;
END;
$$ LANGUAGE plpgsql;

SELECT getDateFin('2025-01-02', 12,2024);


CREATE OR REPLACE FUNCTION getDateDebut(dateDebut DATE, month INT, year INT)
    RETURNS DATE AS $$
BEGIN
    IF month = EXTRACT(MONTH FROM dateDebut) AND year = EXTRACT(YEAR FROM dateDebut) THEN
        RETURN dateDebut;
    ELSEIF make_date(year, month, 1) > dateDebut then
        RETURN MAKE_DATE(year, month, 1);
    else
        return null;
    END IF;
END;
$$ LANGUAGE plpgsql;

SELECT getDateDebut('2024-11-28', 1,2025);

with allMonth as(
    select  gs.month AS mois from generate_series(1,12) as gs(month)
), totalConge as (
    select gs.month as month, COALESCE(
            SUM(
                    GREATEST(
                                (getDateFin(dateFin, gs.month::int, 2024) - getDateDebut(dateDebut, gs.month::int, 2024)) +
                                CASE
                                    WHEN ismatindebut AND ismatinfin THEN 0.5
                                    WHEN ismatindebut AND NOT ismatinfin THEN 1
                                    WHEN NOT ismatindebut AND NOT ismatinfin THEN 0.5
                                    ELSE 0
                                    END, 0)
                ), 0
        ) as total from conge RIGHT JOIN generate_series(1, 12) AS gs(month) ON true
    WHERE
        (EXTRACT(YEAR FROM dateDebut) = 2024 OR EXTRACT(YEAR FROM dateFin) = 2024)
      AND idemp = 1
      AND statut = 'ACCEPTER'
      AND (
                EXTRACT(MONTH FROM dateDebut) = gs.month
            OR EXTRACT(MONTH FROM dateFin) = gs.month
        )
    group by gs.month
) select mois, coalesce(total, 0) from allMonth left join totalConge on mois=month order by mois;


create or replace function getExtraTime(tempDateDebut date, tempDateFin date, dateDebut date, dateFin date, isMatinDebut bool, isMatinFin bool) returns double precision as
$$
declare
    isFinalMatinDebut bool;
    isFinalMatinFin bool;

BEGIN
    if tempDateDebut IS NULL or tempDateFin IS NULL or dateDebut IS NULL or dateFin is null then
        return 0;
    end if;
    if tempDateDebut = dateDebut then
        isFinalMatinDebut := isMatinDebut;
    else
        isFinalMatinDebut := true;
    end if;
    if tempDateFin = dateFin then
        isFinalMatinFin := isMatinFin;
    else
        isFinalMatinFin := false;
    end if;
    if isFinalMatinDebut and isFinalMatinFin then
        return 0.5;
    elseif isFinalMatinDebut AND NOT isFinalMatinFin then
        return 1;
    elseif NOT isFinalMatinDebut AND NOT isFinalMatinFin then
        return 0.5;
    end if;
    return 0;
end;
$$
    LANGUAGE plpgsql;


