insert into type (poste) values ('Direction'),('Ingénieurs en BTP'),('Développeur'),('Technicien'),('Salarié');
insert into genre values (1,'Homme'),(2,'Femme');
insert into statut values (1,'Célibataire'),(2,'Marié(e)'),(3,'Séparé(e)'),(4,'Veuf/veuve'),(5,'En union libre');
insert into niveau values  (1,'< Bac'),(2,'Bac +'),(3,'Licence'),(4,'Master I'),(5,'Master II');
insert into banque values (1,'BOA Madagascar'),(2,'BNI Madagascar'),(3,'Société générale Madagasikara (BFV - SG)'),(4,'BMOI'),(5,'AccèsBanque Madagascar'), (6, 'Aucun');


DELIMITER //

CREATE FUNCTION getDateFin(dateFin DATE, mois INT, anne INT)
    RETURNS DATE
    DETERMINISTIC
BEGIN
IF mois = MONTH(dateFin) AND anne = YEAR(dateFin) THEN
        RETURN dateFin;
ELSEIF DATE_SUB(DATE_ADD(MAKEDATE(anne, 1), INTERVAL mois MONTH), INTERVAL 1 DAY) < dateFin THEN
        RETURN DATE_SUB(DATE_ADD(MAKEDATE(anne, 1), INTERVAL mois MONTH), INTERVAL 1 DAY);
ELSE
        RETURN NULL;
END IF;
END;
//

DELIMITER ;


SELECT getDateFin('2025-01-02', 11,2020);


DELIMITER //
CREATE FUNCTION getDateDebut(dateDebut DATE, month INT, year INT)
    RETURNS DATE
    DETERMINISTIC
BEGIN
IF month = MONTH(dateDebut) AND year = YEAR(dateDebut) THEN
        RETURN dateDebut;
ELSEIF MAKEDATE(year, 1) + INTERVAL (month - 1) MONTH > dateDebut THEN
        RETURN MAKEDATE(year, 1) + INTERVAL (month - 1) MONTH;
ELSE
        RETURN NULL;
END IF;
END;
//
DELIMITER ;


SELECT getDateDebut('2024-11-28', 10,2024);

WITH RECURSIVE allMonth AS (
    SELECT 1 AS mois
    UNION ALL
    SELECT mois + 1
    FROM  allMonth
    WHERE mois < 12
), totalConge AS (
    SELECT
        gs.mois AS month,
        COALESCE(
                SUM(
                        GREATEST(
                                    DATEDIFF(getDateFin(dateFin, gs.mois, 2024), getDateDebut(dateDebut, gs.mois, 2024)) +
                                    CASE
                                        WHEN ismatindebut AND ismatinfin THEN 0.5
                                        WHEN ismatindebut AND NOT ismatinfin THEN 1
                                        WHEN NOT ismatindebut AND NOT ismatinfin THEN 0.5
                                        ELSE 0
                                        END, 0
                            )
                    ), 0
            ) AS total
    FROM conge
             RIGHT JOIN (SELECT mois FROM allMonth) AS gs ON TRUE
    WHERE
        (YEAR(dateDebut) = 2024 OR YEAR(dateFin) = 2024)
      AND idemp = 1
      AND statut = 'ACCEPTER'
      AND (
                MONTH(dateDebut) = gs.mois OR MONTH(dateFin) = gs.mois
        )
    GROUP BY gs.mois
)
SELECT mois, COALESCE(total, 0) AS total
FROM allMonth
         LEFT JOIN totalConge ON mois = month
ORDER BY mois;

DELIMITER //

CREATE FUNCTION getExtraTime(
    tempDateDebut DATE,
    tempDateFin DATE,
    dateDebut DATE,
    dateFin DATE,
    isMatinDebut BOOLEAN,
    isMatinFin BOOLEAN
)
    RETURNS DOUBLE
    DETERMINISTIC
BEGIN
DECLARE isFinalMatinDebut BOOLEAN;
DECLARE isFinalMatinFin BOOLEAN;

IF tempDateDebut IS NULL OR tempDateFin IS NULL OR dateDebut IS NULL OR dateFin IS NULL THEN
        RETURN 0;
END IF;

IF tempDateDebut = dateDebut THEN
SET isFinalMatinDebut = isMatinDebut;
ELSE
SET isFinalMatinDebut = TRUE;
END IF;

IF tempDateFin = dateFin THEN
SET isFinalMatinFin = isMatinFin;
ELSE
SET isFinalMatinFin = FALSE;
END IF;

IF isFinalMatinDebut AND isFinalMatinFin THEN
        RETURN 0.5;
ELSEIF isFinalMatinDebut AND NOT isFinalMatinFin THEN
        RETURN 1;
ELSEIF NOT isFinalMatinDebut AND NOT isFinalMatinFin THEN
        RETURN 0.5;
END IF;

RETURN 0;
END;
//

DELIMITER ;

